/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse;
import software.amazon.awssdk.services.iam.model.SigningCertificate;

public final class ListSigningCertificatesPaginator
implements SdkIterable<ListSigningCertificatesResponse> {
    private final IAMClient client;
    private final ListSigningCertificatesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListSigningCertificatesPaginator(IAMClient client, ListSigningCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSigningCertificatesResponseFetcher();
    }

    public Iterator<ListSigningCertificatesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<SigningCertificate> certificates() {
        Function<ListSigningCertificatesResponse, Iterator> getIterator = response -> response != null ? response.certificates().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListSigningCertificatesResponseFetcher
    implements NextPageFetcher<ListSigningCertificatesResponse> {
        private ListSigningCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListSigningCertificatesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListSigningCertificatesResponse nextPage(ListSigningCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListSigningCertificatesPaginator.this.client.listSigningCertificates(ListSigningCertificatesPaginator.this.firstRequest);
            }
            return ListSigningCertificatesPaginator.this.client.listSigningCertificates((ListSigningCertificatesRequest)((Object)ListSigningCertificatesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

