/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadSSHPublicKeyRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, UploadSSHPublicKeyRequest> {
    private final String userName;
    private final String sshPublicKeyBody;

    private UploadSSHPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.sshPublicKeyBody = builder.sshPublicKeyBody;
    }

    public String userName() {
        return this.userName;
    }

    public String sshPublicKeyBody() {
        return this.sshPublicKeyBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeyBody());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadSSHPublicKeyRequest)) {
            return false;
        }
        UploadSSHPublicKeyRequest other = (UploadSSHPublicKeyRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.sshPublicKeyBody(), other.sshPublicKeyBody());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.sshPublicKeyBody() != null) {
            sb.append("SSHPublicKeyBody: ").append(this.sshPublicKeyBody()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "SSHPublicKeyBody": {
                return Optional.of(clazz.cast(this.sshPublicKeyBody()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String sshPublicKeyBody;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadSSHPublicKeyRequest model) {
            this.userName(model.userName);
            this.sshPublicKeyBody(model.sshPublicKeyBody);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSSHPublicKeyBody() {
            return this.sshPublicKeyBody;
        }

        @Override
        public final Builder sshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
            return this;
        }

        public final void setSSHPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UploadSSHPublicKeyRequest build() {
            return new UploadSSHPublicKeyRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, UploadSSHPublicKeyRequest> {
        public Builder userName(String var1);

        public Builder sshPublicKeyBody(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

