/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.iam.model.PolicySourceType;
import software.amazon.awssdk.services.iam.model.Position;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Statement
implements ToCopyableBuilder<Builder, Statement> {
    private final String sourcePolicyId;
    private final String sourcePolicyType;
    private final Position startPosition;
    private final Position endPosition;

    private Statement(BuilderImpl builder) {
        this.sourcePolicyId = builder.sourcePolicyId;
        this.sourcePolicyType = builder.sourcePolicyType;
        this.startPosition = builder.startPosition;
        this.endPosition = builder.endPosition;
    }

    public String sourcePolicyId() {
        return this.sourcePolicyId;
    }

    public PolicySourceType sourcePolicyType() {
        return PolicySourceType.fromValue(this.sourcePolicyType);
    }

    public String sourcePolicyTypeString() {
        return this.sourcePolicyType;
    }

    public Position startPosition() {
        return this.startPosition;
    }

    public Position endPosition() {
        return this.endPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePolicyTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.endPosition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement other = (Statement)obj;
        return Objects.equals(this.sourcePolicyId(), other.sourcePolicyId()) && Objects.equals(this.sourcePolicyTypeString(), other.sourcePolicyTypeString()) && Objects.equals(this.startPosition(), other.startPosition()) && Objects.equals(this.endPosition(), other.endPosition());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourcePolicyId() != null) {
            sb.append("SourcePolicyId: ").append(this.sourcePolicyId()).append(",");
        }
        if (this.sourcePolicyTypeString() != null) {
            sb.append("SourcePolicyType: ").append(this.sourcePolicyTypeString()).append(",");
        }
        if (this.startPosition() != null) {
            sb.append("StartPosition: ").append(this.startPosition()).append(",");
        }
        if (this.endPosition() != null) {
            sb.append("EndPosition: ").append(this.endPosition()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourcePolicyId": {
                return Optional.of(clazz.cast(this.sourcePolicyId()));
            }
            case "SourcePolicyType": {
                return Optional.of(clazz.cast(this.sourcePolicyTypeString()));
            }
            case "StartPosition": {
                return Optional.of(clazz.cast(this.startPosition()));
            }
            case "EndPosition": {
                return Optional.of(clazz.cast(this.endPosition()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String sourcePolicyId;
        private String sourcePolicyType;
        private Position startPosition;
        private Position endPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(Statement model) {
            this.sourcePolicyId(model.sourcePolicyId);
            this.sourcePolicyType(model.sourcePolicyType);
            this.startPosition(model.startPosition);
            this.endPosition(model.endPosition);
        }

        public final String getSourcePolicyId() {
            return this.sourcePolicyId;
        }

        @Override
        public final Builder sourcePolicyId(String sourcePolicyId) {
            this.sourcePolicyId = sourcePolicyId;
            return this;
        }

        public final void setSourcePolicyId(String sourcePolicyId) {
            this.sourcePolicyId = sourcePolicyId;
        }

        public final String getSourcePolicyType() {
            return this.sourcePolicyType;
        }

        @Override
        public final Builder sourcePolicyType(String sourcePolicyType) {
            this.sourcePolicyType = sourcePolicyType;
            return this;
        }

        @Override
        public final Builder sourcePolicyType(PolicySourceType sourcePolicyType) {
            this.sourcePolicyType(sourcePolicyType.toString());
            return this;
        }

        public final void setSourcePolicyType(String sourcePolicyType) {
            this.sourcePolicyType = sourcePolicyType;
        }

        public final Position.Builder getStartPosition() {
            return this.startPosition != null ? this.startPosition.toBuilder() : null;
        }

        @Override
        public final Builder startPosition(Position startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public final void setStartPosition(Position.BuilderImpl startPosition) {
            this.startPosition = startPosition != null ? startPosition.build() : null;
        }

        public final Position.Builder getEndPosition() {
            return this.endPosition != null ? this.endPosition.toBuilder() : null;
        }

        @Override
        public final Builder endPosition(Position endPosition) {
            this.endPosition = endPosition;
            return this;
        }

        public final void setEndPosition(Position.BuilderImpl endPosition) {
            this.endPosition = endPosition != null ? endPosition.build() : null;
        }

        public Statement build() {
            return new Statement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Statement> {
        public Builder sourcePolicyId(String var1);

        public Builder sourcePolicyType(String var1);

        public Builder sourcePolicyType(PolicySourceType var1);

        public Builder startPosition(Position var1);

        default public Builder startPosition(Consumer<Position.Builder> startPosition) {
            return this.startPosition((Position)((Position.Builder)Position.builder().apply(startPosition)).build());
        }

        public Builder endPosition(Position var1);

        default public Builder endPosition(Consumer<Position.Builder> endPosition) {
            return this.endPosition((Position)((Position.Builder)Position.builder().apply(endPosition)).build());
        }
    }
}

