/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iam.model.ArnListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RoleUsageType
implements ToCopyableBuilder<Builder, RoleUsageType> {
    private final String region;
    private final List<String> resources;

    private RoleUsageType(BuilderImpl builder) {
        this.region = builder.region;
        this.resources = builder.resources;
    }

    public String region() {
        return this.region;
    }

    public List<String> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleUsageType)) {
            return false;
        }
        RoleUsageType other = (RoleUsageType)obj;
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.resources(), other.resources());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.resources() != null) {
            sb.append("Resources: ").append(this.resources()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "Resources": {
                return Optional.of(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private List<String> resources;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleUsageType model) {
            this.region(model.region);
            this.resources(model.resources);
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final Collection<String> getResources() {
            return this.resources;
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = ArnListTypeCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ArnListTypeCopier.copy(resources);
        }

        public RoleUsageType build() {
            return new RoleUsageType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RoleUsageType> {
        public Builder region(String var1);

        public Builder resources(Collection<String> var1);

        public Builder resources(String ... var1);
    }
}

