/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.iam.model.IAMResponse;
import software.amazon.awssdk.services.iam.model.VirtualMFADevice;
import software.amazon.awssdk.services.iam.model._virtualMFADeviceListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListVirtualMFADevicesResponse
extends IAMResponse
implements ToCopyableBuilder<Builder, ListVirtualMFADevicesResponse> {
    private final List<VirtualMFADevice> virtualMFADevices;
    private final Boolean isTruncated;
    private final String marker;

    private ListVirtualMFADevicesResponse(BuilderImpl builder) {
        super(builder);
        this.virtualMFADevices = builder.virtualMFADevices;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<VirtualMFADevice> virtualMFADevices() {
        return this.virtualMFADevices;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualMFADevices());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualMFADevicesResponse)) {
            return false;
        }
        ListVirtualMFADevicesResponse other = (ListVirtualMFADevicesResponse)((Object)obj);
        return Objects.equals(this.virtualMFADevices(), other.virtualMFADevices()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.virtualMFADevices() != null) {
            sb.append("VirtualMFADevices: ").append(this.virtualMFADevices()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VirtualMFADevices": {
                return Optional.of(clazz.cast(this.virtualMFADevices()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMResponse.BuilderImpl
    implements Builder {
        private List<VirtualMFADevice> virtualMFADevices;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualMFADevicesResponse model) {
            this.virtualMFADevices(model.virtualMFADevices);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<VirtualMFADevice.Builder> getVirtualMFADevices() {
            return this.virtualMFADevices != null ? (Collection)this.virtualMFADevices.stream().map(VirtualMFADevice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder virtualMFADevices(Collection<VirtualMFADevice> virtualMFADevices) {
            this.virtualMFADevices = _virtualMFADeviceListTypeCopier.copy(virtualMFADevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualMFADevices(VirtualMFADevice ... virtualMFADevices) {
            this.virtualMFADevices(Arrays.asList(virtualMFADevices));
            return this;
        }

        public final void setVirtualMFADevices(Collection<VirtualMFADevice.BuilderImpl> virtualMFADevices) {
            this.virtualMFADevices = _virtualMFADeviceListTypeCopier.copyFromBuilder(virtualMFADevices);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListVirtualMFADevicesResponse build() {
            return new ListVirtualMFADevicesResponse(this);
        }
    }

    public static interface Builder
    extends IAMResponse.Builder,
    CopyableBuilder<Builder, ListVirtualMFADevicesResponse> {
        public Builder virtualMFADevices(Collection<VirtualMFADevice> var1);

        public Builder virtualMFADevices(VirtualMFADevice ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

