/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.iam.model.DeletionTaskFailureReasonType;
import software.amazon.awssdk.services.iam.model.DeletionTaskStatusType;
import software.amazon.awssdk.services.iam.model.IAMResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetServiceLinkedRoleDeletionStatusResponse
extends IAMResponse
implements ToCopyableBuilder<Builder, GetServiceLinkedRoleDeletionStatusResponse> {
    private final String status;
    private final DeletionTaskFailureReasonType reason;

    private GetServiceLinkedRoleDeletionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.reason = builder.reason;
    }

    public DeletionTaskStatusType status() {
        return DeletionTaskStatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public DeletionTaskFailureReasonType reason() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceLinkedRoleDeletionStatusResponse)) {
            return false;
        }
        GetServiceLinkedRoleDeletionStatusResponse other = (GetServiceLinkedRoleDeletionStatusResponse)((Object)obj);
        return Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.reason(), other.reason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.reason() != null) {
            sb.append("Reason: ").append(this.reason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "Reason": {
                return Optional.of(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMResponse.BuilderImpl
    implements Builder {
        private String status;
        private DeletionTaskFailureReasonType reason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceLinkedRoleDeletionStatusResponse model) {
            this.status(model.status);
            this.reason(model.reason);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeletionTaskStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final DeletionTaskFailureReasonType.Builder getReason() {
            return this.reason != null ? this.reason.toBuilder() : null;
        }

        @Override
        public final Builder reason(DeletionTaskFailureReasonType reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(DeletionTaskFailureReasonType.BuilderImpl reason) {
            this.reason = reason != null ? reason.build() : null;
        }

        @Override
        public GetServiceLinkedRoleDeletionStatusResponse build() {
            return new GetServiceLinkedRoleDeletionStatusResponse(this);
        }
    }

    public static interface Builder
    extends IAMResponse.Builder,
    CopyableBuilder<Builder, GetServiceLinkedRoleDeletionStatusResponse> {
        public Builder status(String var1);

        public Builder status(DeletionTaskStatusType var1);

        public Builder reason(DeletionTaskFailureReasonType var1);

        default public Builder reason(Consumer<DeletionTaskFailureReasonType.Builder> reason) {
            return this.reason((DeletionTaskFailureReasonType)((DeletionTaskFailureReasonType.Builder)DeletionTaskFailureReasonType.builder().apply(reason)).build());
        }
    }
}

