/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVirtualMFADeviceRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, CreateVirtualMFADeviceRequest> {
    private final String path;
    private final String virtualMFADeviceName;

    private CreateVirtualMFADeviceRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
        this.virtualMFADeviceName = builder.virtualMFADeviceName;
    }

    public String path() {
        return this.path;
    }

    public String virtualMFADeviceName() {
        return this.virtualMFADeviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualMFADeviceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVirtualMFADeviceRequest)) {
            return false;
        }
        CreateVirtualMFADeviceRequest other = (CreateVirtualMFADeviceRequest)((Object)obj);
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.virtualMFADeviceName(), other.virtualMFADeviceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.virtualMFADeviceName() != null) {
            sb.append("VirtualMFADeviceName: ").append(this.virtualMFADeviceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "VirtualMFADeviceName": {
                return Optional.of(clazz.cast(this.virtualMFADeviceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String path;
        private String virtualMFADeviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVirtualMFADeviceRequest model) {
            this.path(model.path);
            this.virtualMFADeviceName(model.virtualMFADeviceName);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getVirtualMFADeviceName() {
            return this.virtualMFADeviceName;
        }

        @Override
        public final Builder virtualMFADeviceName(String virtualMFADeviceName) {
            this.virtualMFADeviceName = virtualMFADeviceName;
            return this;
        }

        public final void setVirtualMFADeviceName(String virtualMFADeviceName) {
            this.virtualMFADeviceName = virtualMFADeviceName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateVirtualMFADeviceRequest build() {
            return new CreateVirtualMFADeviceRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, CreateVirtualMFADeviceRequest> {
        public Builder path(String var1);

        public Builder virtualMFADeviceName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

