/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePolicyRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, CreatePolicyRequest> {
    private final String policyName;
    private final String path;
    private final String policyDocument;
    private final String description;

    private CreatePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.path = builder.path;
        this.policyDocument = builder.policyDocument;
        this.description = builder.description;
    }

    public String policyName() {
        return this.policyName;
    }

    public String path() {
        return this.path;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyRequest)) {
            return false;
        }
        CreatePolicyRequest other = (CreatePolicyRequest)((Object)obj);
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.policyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.policyDocument()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "PolicyDocument": {
                return Optional.of(clazz.cast(this.policyDocument()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String policyName;
        private String path;
        private String policyDocument;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyRequest model) {
            this.policyName(model.policyName);
            this.path(model.path);
            this.policyDocument(model.policyDocument);
            this.description(model.description);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreatePolicyRequest build() {
            return new CreatePolicyRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, CreatePolicyRequest> {
        public Builder policyName(String var1);

        public Builder path(String var1);

        public Builder policyDocument(String var1);

        public Builder description(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

