/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateGroupRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, CreateGroupRequest> {
    private final String path;
    private final String groupName;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
        this.groupName = builder.groupName;
    }

    public String path() {
        return this.path;
    }

    public String groupName() {
        return this.groupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest)((Object)obj);
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.groupName(), other.groupName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String path;
        private String groupName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            this.path(model.path);
            this.groupName(model.groupName);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, CreateGroupRequest> {
        public Builder path(String var1);

        public Builder groupName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

