/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.ResyncMFADeviceRequest;

public class ResyncMFADeviceRequestMarshaller
implements Marshaller<Request<ResyncMFADeviceRequest>, ResyncMFADeviceRequest> {
    public Request<ResyncMFADeviceRequest> marshall(ResyncMFADeviceRequest resyncMFADeviceRequest) {
        if (resyncMFADeviceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resyncMFADeviceRequest, "IAMClient");
        request.addParameter("Action", "ResyncMFADevice");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (resyncMFADeviceRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)resyncMFADeviceRequest.userName()));
        }
        if (resyncMFADeviceRequest.serialNumber() != null) {
            request.addParameter("SerialNumber", StringUtils.fromString((String)resyncMFADeviceRequest.serialNumber()));
        }
        if (resyncMFADeviceRequest.authenticationCode1() != null) {
            request.addParameter("AuthenticationCode1", StringUtils.fromString((String)resyncMFADeviceRequest.authenticationCode1()));
        }
        if (resyncMFADeviceRequest.authenticationCode2() != null) {
            request.addParameter("AuthenticationCode2", StringUtils.fromString((String)resyncMFADeviceRequest.authenticationCode2()));
        }
        return request;
    }
}

