/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.EvaluationResult;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse;

public final class SimulateCustomPolicyPaginator
implements SdkIterable<SimulateCustomPolicyResponse> {
    private final IAMClient client;
    private final SimulateCustomPolicyRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public SimulateCustomPolicyPaginator(IAMClient client, SimulateCustomPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SimulateCustomPolicyResponseFetcher();
    }

    public Iterator<SimulateCustomPolicyResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<EvaluationResult> evaluationResults() {
        Function<SimulateCustomPolicyResponse, Iterator> getIterator = response -> response != null ? response.evaluationResults().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class SimulateCustomPolicyResponseFetcher
    implements NextPageFetcher<SimulateCustomPolicyResponse> {
        private SimulateCustomPolicyResponseFetcher() {
        }

        public boolean hasNextPage(SimulateCustomPolicyResponse previousPage) {
            return previousPage.isTruncated();
        }

        public SimulateCustomPolicyResponse nextPage(SimulateCustomPolicyResponse previousPage) {
            if (previousPage == null) {
                return SimulateCustomPolicyPaginator.this.client.simulateCustomPolicy(SimulateCustomPolicyPaginator.this.firstRequest);
            }
            return SimulateCustomPolicyPaginator.this.client.simulateCustomPolicy((SimulateCustomPolicyRequest)((Object)SimulateCustomPolicyPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

