/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse;

public final class ListInstanceProfilesForRolePaginator
implements SdkIterable<ListInstanceProfilesForRoleResponse> {
    private final IAMClient client;
    private final ListInstanceProfilesForRoleRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListInstanceProfilesForRolePaginator(IAMClient client, ListInstanceProfilesForRoleRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstanceProfilesForRoleResponseFetcher();
    }

    public Iterator<ListInstanceProfilesForRoleResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<InstanceProfile> instanceProfiles() {
        Function<ListInstanceProfilesForRoleResponse, Iterator> getIterator = response -> response != null ? response.instanceProfiles().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListInstanceProfilesForRoleResponseFetcher
    implements NextPageFetcher<ListInstanceProfilesForRoleResponse> {
        private ListInstanceProfilesForRoleResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceProfilesForRoleResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListInstanceProfilesForRoleResponse nextPage(ListInstanceProfilesForRoleResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceProfilesForRolePaginator.this.client.listInstanceProfilesForRole(ListInstanceProfilesForRolePaginator.this.firstRequest);
            }
            return ListInstanceProfilesForRolePaginator.this.client.listInstanceProfilesForRole((ListInstanceProfilesForRoleRequest)((Object)ListInstanceProfilesForRolePaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

