/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse;

public final class ListGroupsForUserPaginator
implements SdkIterable<ListGroupsForUserResponse> {
    private final IAMClient client;
    private final ListGroupsForUserRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListGroupsForUserPaginator(IAMClient client, ListGroupsForUserRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupsForUserResponseFetcher();
    }

    public Iterator<ListGroupsForUserResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Group> groups() {
        Function<ListGroupsForUserResponse, Iterator> getIterator = response -> response != null ? response.groups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListGroupsForUserResponseFetcher
    implements NextPageFetcher<ListGroupsForUserResponse> {
        private ListGroupsForUserResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsForUserResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListGroupsForUserResponse nextPage(ListGroupsForUserResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsForUserPaginator.this.client.listGroupsForUser(ListGroupsForUserPaginator.this.firstRequest);
            }
            return ListGroupsForUserPaginator.this.client.listGroupsForUser((ListGroupsForUserRequest)((Object)ListGroupsForUserPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

