/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse;

public final class ListAttachedUserPoliciesPaginator
implements SdkIterable<ListAttachedUserPoliciesResponse> {
    private final IAMClient client;
    private final ListAttachedUserPoliciesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAttachedUserPoliciesPaginator(IAMClient client, ListAttachedUserPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttachedUserPoliciesResponseFetcher();
    }

    public Iterator<ListAttachedUserPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<AttachedPolicy> attachedPolicies() {
        Function<ListAttachedUserPoliciesResponse, Iterator> getIterator = response -> response != null ? response.attachedPolicies().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListAttachedUserPoliciesResponseFetcher
    implements NextPageFetcher<ListAttachedUserPoliciesResponse> {
        private ListAttachedUserPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedUserPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAttachedUserPoliciesResponse nextPage(ListAttachedUserPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedUserPoliciesPaginator.this.client.listAttachedUserPolicies(ListAttachedUserPoliciesPaginator.this.firstRequest);
            }
            return ListAttachedUserPoliciesPaginator.this.client.listAttachedUserPolicies((ListAttachedUserPoliciesRequest)((Object)ListAttachedUserPoliciesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

