/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse;
import software.amazon.awssdk.services.iam.model.GroupDetail;
import software.amazon.awssdk.services.iam.model.ManagedPolicyDetail;
import software.amazon.awssdk.services.iam.model.RoleDetail;
import software.amazon.awssdk.services.iam.model.UserDetail;

public final class GetAccountAuthorizationDetailsPaginator
implements SdkIterable<GetAccountAuthorizationDetailsResponse> {
    private final IAMClient client;
    private final GetAccountAuthorizationDetailsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetAccountAuthorizationDetailsPaginator(IAMClient client, GetAccountAuthorizationDetailsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetAccountAuthorizationDetailsResponseFetcher();
    }

    public Iterator<GetAccountAuthorizationDetailsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<UserDetail> userDetailList() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> response != null ? response.userDetailList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public SdkIterable<GroupDetail> groupDetailList() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> response != null ? response.groupDetailList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public SdkIterable<RoleDetail> roleDetailList() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> response != null ? response.roleDetailList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public SdkIterable<ManagedPolicyDetail> policies() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> response != null ? response.policies().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class GetAccountAuthorizationDetailsResponseFetcher
    implements NextPageFetcher<GetAccountAuthorizationDetailsResponse> {
        private GetAccountAuthorizationDetailsResponseFetcher() {
        }

        public boolean hasNextPage(GetAccountAuthorizationDetailsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public GetAccountAuthorizationDetailsResponse nextPage(GetAccountAuthorizationDetailsResponse previousPage) {
            if (previousPage == null) {
                return GetAccountAuthorizationDetailsPaginator.this.client.getAccountAuthorizationDetails(GetAccountAuthorizationDetailsPaginator.this.firstRequest);
            }
            return GetAccountAuthorizationDetailsPaginator.this.client.getAccountAuthorizationDetails((GetAccountAuthorizationDetailsRequest)((Object)GetAccountAuthorizationDetailsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

