/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.iam.model._thumbprintListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateOpenIDConnectProviderThumbprintRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateOpenIDConnectProviderThumbprintRequest> {
    private final String openIDConnectProviderArn;
    private final List<String> thumbprintList;

    private UpdateOpenIDConnectProviderThumbprintRequest(BuilderImpl builder) {
        this.openIDConnectProviderArn = builder.openIDConnectProviderArn;
        this.thumbprintList = builder.thumbprintList;
    }

    public String openIDConnectProviderArn() {
        return this.openIDConnectProviderArn;
    }

    public List<String> thumbprintList() {
        return this.thumbprintList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbprintList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpenIDConnectProviderThumbprintRequest)) {
            return false;
        }
        UpdateOpenIDConnectProviderThumbprintRequest other = (UpdateOpenIDConnectProviderThumbprintRequest)((Object)obj);
        return Objects.equals(this.openIDConnectProviderArn(), other.openIDConnectProviderArn()) && Objects.equals(this.thumbprintList(), other.thumbprintList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.openIDConnectProviderArn() != null) {
            sb.append("OpenIDConnectProviderArn: ").append(this.openIDConnectProviderArn()).append(",");
        }
        if (this.thumbprintList() != null) {
            sb.append("ThumbprintList: ").append(this.thumbprintList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpenIDConnectProviderArn": {
                return Optional.of(clazz.cast(this.openIDConnectProviderArn()));
            }
            case "ThumbprintList": {
                return Optional.of(clazz.cast(this.thumbprintList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String openIDConnectProviderArn;
        private List<String> thumbprintList;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpenIDConnectProviderThumbprintRequest model) {
            this.openIDConnectProviderArn(model.openIDConnectProviderArn);
            this.thumbprintList(model.thumbprintList);
        }

        public final String getOpenIDConnectProviderArn() {
            return this.openIDConnectProviderArn;
        }

        @Override
        public final Builder openIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
            return this;
        }

        public final void setOpenIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
        }

        public final Collection<String> getThumbprintList() {
            return this.thumbprintList;
        }

        @Override
        public final Builder thumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbprintList(String ... thumbprintList) {
            this.thumbprintList(Arrays.asList(thumbprintList));
            return this;
        }

        public final void setThumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
        }

        public UpdateOpenIDConnectProviderThumbprintRequest build() {
            return new UpdateOpenIDConnectProviderThumbprintRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateOpenIDConnectProviderThumbprintRequest> {
        public Builder openIDConnectProviderArn(String var1);

        public Builder thumbprintList(Collection<String> var1);

        public Builder thumbprintList(String ... var1);
    }
}

