/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Role
implements ToCopyableBuilder<Builder, Role> {
    private final String path;
    private final String roleName;
    private final String roleId;
    private final String arn;
    private final Instant createDate;
    private final String assumeRolePolicyDocument;
    private final String description;

    private Role(BuilderImpl builder) {
        this.path = builder.path;
        this.roleName = builder.roleName;
        this.roleId = builder.roleId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.description = builder.description;
    }

    public String path() {
        return this.path;
    }

    public String roleName() {
        return this.roleName;
    }

    public String roleId() {
        return this.roleId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public String assumeRolePolicyDocument() {
        return this.assumeRolePolicyDocument;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.roleId(), other.roleId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.assumeRolePolicyDocument(), other.assumeRolePolicyDocument()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.roleName() != null) {
            sb.append("RoleName: ").append(this.roleName()).append(",");
        }
        if (this.roleId() != null) {
            sb.append("RoleId: ").append(this.roleId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.assumeRolePolicyDocument() != null) {
            sb.append("AssumeRolePolicyDocument: ").append(this.assumeRolePolicyDocument()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "RoleName": {
                return Optional.of(clazz.cast(this.roleName()));
            }
            case "RoleId": {
                return Optional.of(clazz.cast(this.roleId()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "AssumeRolePolicyDocument": {
                return Optional.of(clazz.cast(this.assumeRolePolicyDocument()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String roleName;
        private String roleId;
        private String arn;
        private Instant createDate;
        private String assumeRolePolicyDocument;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(Role model) {
            this.path(model.path);
            this.roleName(model.roleName);
            this.roleId(model.roleId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            this.description(model.description);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getRoleId() {
            return this.roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getAssumeRolePolicyDocument() {
            return this.assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public Role build() {
            return new Role(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Role> {
        public Builder path(String var1);

        public Builder roleName(String var1);

        public Builder roleId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder assumeRolePolicyDocument(String var1);

        public Builder description(String var1);
    }
}

