/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Policy
implements ToCopyableBuilder<Builder, Policy> {
    private final String policyName;
    private final String policyId;
    private final String arn;
    private final String path;
    private final String defaultVersionId;
    private final Integer attachmentCount;
    private final Boolean isAttachable;
    private final String description;
    private final Instant createDate;
    private final Instant updateDate;

    private Policy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyId = builder.policyId;
        this.arn = builder.arn;
        this.path = builder.path;
        this.defaultVersionId = builder.defaultVersionId;
        this.attachmentCount = builder.attachmentCount;
        this.isAttachable = builder.isAttachable;
        this.description = builder.description;
        this.createDate = builder.createDate;
        this.updateDate = builder.updateDate;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyId() {
        return this.policyId;
    }

    public String arn() {
        return this.arn;
    }

    public String path() {
        return this.path;
    }

    public String defaultVersionId() {
        return this.defaultVersionId;
    }

    public Integer attachmentCount() {
        return this.attachmentCount;
    }

    public Boolean isAttachable() {
        return this.isAttachable;
    }

    public String description() {
        return this.description;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Instant updateDate() {
        return this.updateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAttachable());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.defaultVersionId(), other.defaultVersionId()) && Objects.equals(this.attachmentCount(), other.attachmentCount()) && Objects.equals(this.isAttachable(), other.isAttachable()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.updateDate(), other.updateDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.policyId() != null) {
            sb.append("PolicyId: ").append(this.policyId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.defaultVersionId() != null) {
            sb.append("DefaultVersionId: ").append(this.defaultVersionId()).append(",");
        }
        if (this.attachmentCount() != null) {
            sb.append("AttachmentCount: ").append(this.attachmentCount()).append(",");
        }
        if (this.isAttachable() != null) {
            sb.append("IsAttachable: ").append(this.isAttachable()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.updateDate() != null) {
            sb.append("UpdateDate: ").append(this.updateDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "PolicyId": {
                return Optional.of(clazz.cast(this.policyId()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "DefaultVersionId": {
                return Optional.of(clazz.cast(this.defaultVersionId()));
            }
            case "AttachmentCount": {
                return Optional.of(clazz.cast(this.attachmentCount()));
            }
            case "IsAttachable": {
                return Optional.of(clazz.cast(this.isAttachable()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "UpdateDate": {
                return Optional.of(clazz.cast(this.updateDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyId;
        private String arn;
        private String path;
        private String defaultVersionId;
        private Integer attachmentCount;
        private Boolean isAttachable;
        private String description;
        private Instant createDate;
        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Policy model) {
            this.policyName(model.policyName);
            this.policyId(model.policyId);
            this.arn(model.arn);
            this.path(model.path);
            this.defaultVersionId(model.defaultVersionId);
            this.attachmentCount(model.attachmentCount);
            this.isAttachable(model.isAttachable);
            this.description(model.description);
            this.createDate(model.createDate);
            this.updateDate(model.updateDate);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getDefaultVersionId() {
            return this.defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        public final Integer getAttachmentCount() {
            return this.attachmentCount;
        }

        @Override
        public final Builder attachmentCount(Integer attachmentCount) {
            this.attachmentCount = attachmentCount;
            return this;
        }

        public final void setAttachmentCount(Integer attachmentCount) {
            this.attachmentCount = attachmentCount;
        }

        public final Boolean getIsAttachable() {
            return this.isAttachable;
        }

        @Override
        public final Builder isAttachable(Boolean isAttachable) {
            this.isAttachable = isAttachable;
            return this;
        }

        public final void setIsAttachable(Boolean isAttachable) {
            this.isAttachable = isAttachable;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public Policy build() {
            return new Policy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Policy> {
        public Builder policyName(String var1);

        public Builder policyId(String var1);

        public Builder arn(String var1);

        public Builder path(String var1);

        public Builder defaultVersionId(String var1);

        public Builder attachmentCount(Integer var1);

        public Builder isAttachable(Boolean var1);

        public Builder description(String var1);

        public Builder createDate(Instant var1);

        public Builder updateDate(Instant var1);
    }
}

