/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MFADevice
implements ToCopyableBuilder<Builder, MFADevice> {
    private final String userName;
    private final String serialNumber;
    private final Instant enableDate;

    private MFADevice(BuilderImpl builder) {
        this.userName = builder.userName;
        this.serialNumber = builder.serialNumber;
        this.enableDate = builder.enableDate;
    }

    public String userName() {
        return this.userName;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public Instant enableDate() {
        return this.enableDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MFADevice)) {
            return false;
        }
        MFADevice other = (MFADevice)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.enableDate(), other.enableDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.serialNumber() != null) {
            sb.append("SerialNumber: ").append(this.serialNumber()).append(",");
        }
        if (this.enableDate() != null) {
            sb.append("EnableDate: ").append(this.enableDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "SerialNumber": {
                return Optional.of(clazz.cast(this.serialNumber()));
            }
            case "EnableDate": {
                return Optional.of(clazz.cast(this.enableDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String serialNumber;
        private Instant enableDate;

        private BuilderImpl() {
        }

        private BuilderImpl(MFADevice model) {
            this.userName(model.userName);
            this.serialNumber(model.serialNumber);
            this.enableDate(model.enableDate);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final Instant getEnableDate() {
            return this.enableDate;
        }

        @Override
        public final Builder enableDate(Instant enableDate) {
            this.enableDate = enableDate;
            return this;
        }

        public final void setEnableDate(Instant enableDate) {
            this.enableDate = enableDate;
        }

        public MFADevice build() {
            return new MFADevice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MFADevice> {
        public Builder userName(String var1);

        public Builder serialNumber(String var1);

        public Builder enableDate(Instant var1);
    }
}

