/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.iam.model.RoleUsageListTypeCopier;
import software.amazon.awssdk.services.iam.model.RoleUsageType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeletionTaskFailureReasonType
implements ToCopyableBuilder<Builder, DeletionTaskFailureReasonType> {
    private final String reason;
    private final List<RoleUsageType> roleUsageList;

    private DeletionTaskFailureReasonType(BuilderImpl builder) {
        this.reason = builder.reason;
        this.roleUsageList = builder.roleUsageList;
    }

    public String reason() {
        return this.reason;
    }

    public List<RoleUsageType> roleUsageList() {
        return this.roleUsageList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleUsageList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletionTaskFailureReasonType)) {
            return false;
        }
        DeletionTaskFailureReasonType other = (DeletionTaskFailureReasonType)obj;
        return Objects.equals(this.reason(), other.reason()) && Objects.equals(this.roleUsageList(), other.roleUsageList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.reason() != null) {
            sb.append("Reason: ").append(this.reason()).append(",");
        }
        if (this.roleUsageList() != null) {
            sb.append("RoleUsageList: ").append(this.roleUsageList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Reason": {
                return Optional.of(clazz.cast(this.reason()));
            }
            case "RoleUsageList": {
                return Optional.of(clazz.cast(this.roleUsageList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String reason;
        private List<RoleUsageType> roleUsageList;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletionTaskFailureReasonType model) {
            this.reason(model.reason);
            this.roleUsageList(model.roleUsageList);
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Collection<RoleUsageType.Builder> getRoleUsageList() {
            return this.roleUsageList != null ? (Collection)this.roleUsageList.stream().map(RoleUsageType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roleUsageList(Collection<RoleUsageType> roleUsageList) {
            this.roleUsageList = RoleUsageListTypeCopier.copy(roleUsageList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleUsageList(RoleUsageType ... roleUsageList) {
            this.roleUsageList(Arrays.asList(roleUsageList));
            return this;
        }

        public final void setRoleUsageList(Collection<RoleUsageType.BuilderImpl> roleUsageList) {
            this.roleUsageList = RoleUsageListTypeCopier.copyFromBuilder(roleUsageList);
        }

        public DeletionTaskFailureReasonType build() {
            return new DeletionTaskFailureReasonType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeletionTaskFailureReasonType> {
        public Builder reason(String var1);

        public Builder roleUsageList(Collection<RoleUsageType> var1);

        public Builder roleUsageList(RoleUsageType ... var1);
    }
}

