/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.UpdateSAMLProviderRequest;

public class UpdateSAMLProviderRequestMarshaller
implements Marshaller<Request<UpdateSAMLProviderRequest>, UpdateSAMLProviderRequest> {
    public Request<UpdateSAMLProviderRequest> marshall(UpdateSAMLProviderRequest updateSAMLProviderRequest) {
        if (updateSAMLProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateSAMLProviderRequest, "IAMClient");
        request.addParameter("Action", "UpdateSAMLProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateSAMLProviderRequest.samlMetadataDocument() != null) {
            request.addParameter("SAMLMetadataDocument", StringUtils.fromString((String)updateSAMLProviderRequest.samlMetadataDocument()));
        }
        if (updateSAMLProviderRequest.samlProviderArn() != null) {
            request.addParameter("SAMLProviderArn", StringUtils.fromString((String)updateSAMLProviderRequest.samlProviderArn()));
        }
        return request;
    }
}

