/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.ListGroupsRequest;

public class ListGroupsRequestMarshaller
implements Marshaller<Request<ListGroupsRequest>, ListGroupsRequest> {
    public Request<ListGroupsRequest> marshall(ListGroupsRequest listGroupsRequest) {
        if (listGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listGroupsRequest, "IAMClient");
        request.addParameter("Action", "ListGroups");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listGroupsRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringUtils.fromString((String)listGroupsRequest.pathPrefix()));
        }
        if (listGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listGroupsRequest.marker()));
        }
        if (listGroupsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listGroupsRequest.maxItems()));
        }
        return request;
    }
}

