/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.GetOpenIDConnectProviderRequest;

public class GetOpenIDConnectProviderRequestMarshaller
implements Marshaller<Request<GetOpenIDConnectProviderRequest>, GetOpenIDConnectProviderRequest> {
    public Request<GetOpenIDConnectProviderRequest> marshall(GetOpenIDConnectProviderRequest getOpenIDConnectProviderRequest) {
        if (getOpenIDConnectProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getOpenIDConnectProviderRequest, "IAMClient");
        request.addParameter("Action", "GetOpenIDConnectProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getOpenIDConnectProviderRequest.openIDConnectProviderArn() != null) {
            request.addParameter("OpenIDConnectProviderArn", StringUtils.fromString((String)getOpenIDConnectProviderRequest.openIDConnectProviderArn()));
        }
        return request;
    }
}

