/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.DeleteRoleRequest;

public class DeleteRoleRequestMarshaller
implements Marshaller<Request<DeleteRoleRequest>, DeleteRoleRequest> {
    public Request<DeleteRoleRequest> marshall(DeleteRoleRequest deleteRoleRequest) {
        if (deleteRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteRoleRequest, "IAMClient");
        request.addParameter("Action", "DeleteRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteRoleRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)deleteRoleRequest.roleName()));
        }
        return request;
    }
}

