/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.ChangePasswordRequest;

public class ChangePasswordRequestMarshaller
implements Marshaller<Request<ChangePasswordRequest>, ChangePasswordRequest> {
    public Request<ChangePasswordRequest> marshall(ChangePasswordRequest changePasswordRequest) {
        if (changePasswordRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)changePasswordRequest, "IAMClient");
        request.addParameter("Action", "ChangePassword");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (changePasswordRequest.oldPassword() != null) {
            request.addParameter("OldPassword", StringUtils.fromString((String)changePasswordRequest.oldPassword()));
        }
        if (changePasswordRequest.newPassword() != null) {
            request.addParameter("NewPassword", StringUtils.fromString((String)changePasswordRequest.newPassword()));
        }
        return request;
    }
}

