/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateUserRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateUserRequest> {
    private final String userName;
    private final String newPath;
    private final String newUserName;

    private UpdateUserRequest(BuilderImpl builder) {
        this.userName = builder.userName;
        this.newPath = builder.newPath;
        this.newUserName = builder.newUserName;
    }

    public String userName() {
        return this.userName;
    }

    public String newPath() {
        return this.newPath;
    }

    public String newUserName() {
        return this.newUserName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.newPath() == null ? 0 : this.newPath().hashCode());
        hashCode = 31 * hashCode + (this.newUserName() == null ? 0 : this.newUserName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)((Object)obj);
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.newPath() == null ^ this.newPath() == null) {
            return false;
        }
        if (other.newPath() != null && !other.newPath().equals(this.newPath())) {
            return false;
        }
        if (other.newUserName() == null ^ this.newUserName() == null) {
            return false;
        }
        return other.newUserName() == null || other.newUserName().equals(this.newUserName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.newPath() != null) {
            sb.append("NewPath: ").append(this.newPath()).append(",");
        }
        if (this.newUserName() != null) {
            sb.append("NewUserName: ").append(this.newUserName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "NewPath": {
                return Optional.of(clazz.cast(this.newPath()));
            }
            case "NewUserName": {
                return Optional.of(clazz.cast(this.newUserName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String newPath;
        private String newUserName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            this.userName(model.userName);
            this.newPath(model.newPath);
            this.newUserName(model.newUserName);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getNewPath() {
            return this.newPath;
        }

        @Override
        public final Builder newPath(String newPath) {
            this.newPath = newPath;
            return this;
        }

        public final void setNewPath(String newPath) {
            this.newPath = newPath;
        }

        public final String getNewUserName() {
            return this.newUserName;
        }

        @Override
        public final Builder newUserName(String newUserName) {
            this.newUserName = newUserName;
            return this;
        }

        public final void setNewUserName(String newUserName) {
            this.newUserName = newUserName;
        }

        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateUserRequest> {
        public Builder userName(String var1);

        public Builder newPath(String var1);

        public Builder newUserName(String var1);
    }
}

