/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateAccountPasswordPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateAccountPasswordPolicyRequest> {
    private final Integer minimumPasswordLength;
    private final Boolean requireSymbols;
    private final Boolean requireNumbers;
    private final Boolean requireUppercaseCharacters;
    private final Boolean requireLowercaseCharacters;
    private final Boolean allowUsersToChangePassword;
    private final Integer maxPasswordAge;
    private final Integer passwordReusePrevention;
    private final Boolean hardExpiry;

    private UpdateAccountPasswordPolicyRequest(BuilderImpl builder) {
        this.minimumPasswordLength = builder.minimumPasswordLength;
        this.requireSymbols = builder.requireSymbols;
        this.requireNumbers = builder.requireNumbers;
        this.requireUppercaseCharacters = builder.requireUppercaseCharacters;
        this.requireLowercaseCharacters = builder.requireLowercaseCharacters;
        this.allowUsersToChangePassword = builder.allowUsersToChangePassword;
        this.maxPasswordAge = builder.maxPasswordAge;
        this.passwordReusePrevention = builder.passwordReusePrevention;
        this.hardExpiry = builder.hardExpiry;
    }

    public Integer minimumPasswordLength() {
        return this.minimumPasswordLength;
    }

    public Boolean requireSymbols() {
        return this.requireSymbols;
    }

    public Boolean requireNumbers() {
        return this.requireNumbers;
    }

    public Boolean requireUppercaseCharacters() {
        return this.requireUppercaseCharacters;
    }

    public Boolean requireLowercaseCharacters() {
        return this.requireLowercaseCharacters;
    }

    public Boolean allowUsersToChangePassword() {
        return this.allowUsersToChangePassword;
    }

    public Integer maxPasswordAge() {
        return this.maxPasswordAge;
    }

    public Integer passwordReusePrevention() {
        return this.passwordReusePrevention;
    }

    public Boolean hardExpiry() {
        return this.hardExpiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.minimumPasswordLength() == null ? 0 : this.minimumPasswordLength().hashCode());
        hashCode = 31 * hashCode + (this.requireSymbols() == null ? 0 : this.requireSymbols().hashCode());
        hashCode = 31 * hashCode + (this.requireNumbers() == null ? 0 : this.requireNumbers().hashCode());
        hashCode = 31 * hashCode + (this.requireUppercaseCharacters() == null ? 0 : this.requireUppercaseCharacters().hashCode());
        hashCode = 31 * hashCode + (this.requireLowercaseCharacters() == null ? 0 : this.requireLowercaseCharacters().hashCode());
        hashCode = 31 * hashCode + (this.allowUsersToChangePassword() == null ? 0 : this.allowUsersToChangePassword().hashCode());
        hashCode = 31 * hashCode + (this.maxPasswordAge() == null ? 0 : this.maxPasswordAge().hashCode());
        hashCode = 31 * hashCode + (this.passwordReusePrevention() == null ? 0 : this.passwordReusePrevention().hashCode());
        hashCode = 31 * hashCode + (this.hardExpiry() == null ? 0 : this.hardExpiry().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountPasswordPolicyRequest)) {
            return false;
        }
        UpdateAccountPasswordPolicyRequest other = (UpdateAccountPasswordPolicyRequest)((Object)obj);
        if (other.minimumPasswordLength() == null ^ this.minimumPasswordLength() == null) {
            return false;
        }
        if (other.minimumPasswordLength() != null && !other.minimumPasswordLength().equals(this.minimumPasswordLength())) {
            return false;
        }
        if (other.requireSymbols() == null ^ this.requireSymbols() == null) {
            return false;
        }
        if (other.requireSymbols() != null && !other.requireSymbols().equals(this.requireSymbols())) {
            return false;
        }
        if (other.requireNumbers() == null ^ this.requireNumbers() == null) {
            return false;
        }
        if (other.requireNumbers() != null && !other.requireNumbers().equals(this.requireNumbers())) {
            return false;
        }
        if (other.requireUppercaseCharacters() == null ^ this.requireUppercaseCharacters() == null) {
            return false;
        }
        if (other.requireUppercaseCharacters() != null && !other.requireUppercaseCharacters().equals(this.requireUppercaseCharacters())) {
            return false;
        }
        if (other.requireLowercaseCharacters() == null ^ this.requireLowercaseCharacters() == null) {
            return false;
        }
        if (other.requireLowercaseCharacters() != null && !other.requireLowercaseCharacters().equals(this.requireLowercaseCharacters())) {
            return false;
        }
        if (other.allowUsersToChangePassword() == null ^ this.allowUsersToChangePassword() == null) {
            return false;
        }
        if (other.allowUsersToChangePassword() != null && !other.allowUsersToChangePassword().equals(this.allowUsersToChangePassword())) {
            return false;
        }
        if (other.maxPasswordAge() == null ^ this.maxPasswordAge() == null) {
            return false;
        }
        if (other.maxPasswordAge() != null && !other.maxPasswordAge().equals(this.maxPasswordAge())) {
            return false;
        }
        if (other.passwordReusePrevention() == null ^ this.passwordReusePrevention() == null) {
            return false;
        }
        if (other.passwordReusePrevention() != null && !other.passwordReusePrevention().equals(this.passwordReusePrevention())) {
            return false;
        }
        if (other.hardExpiry() == null ^ this.hardExpiry() == null) {
            return false;
        }
        return other.hardExpiry() == null || other.hardExpiry().equals(this.hardExpiry());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.minimumPasswordLength() != null) {
            sb.append("MinimumPasswordLength: ").append(this.minimumPasswordLength()).append(",");
        }
        if (this.requireSymbols() != null) {
            sb.append("RequireSymbols: ").append(this.requireSymbols()).append(",");
        }
        if (this.requireNumbers() != null) {
            sb.append("RequireNumbers: ").append(this.requireNumbers()).append(",");
        }
        if (this.requireUppercaseCharacters() != null) {
            sb.append("RequireUppercaseCharacters: ").append(this.requireUppercaseCharacters()).append(",");
        }
        if (this.requireLowercaseCharacters() != null) {
            sb.append("RequireLowercaseCharacters: ").append(this.requireLowercaseCharacters()).append(",");
        }
        if (this.allowUsersToChangePassword() != null) {
            sb.append("AllowUsersToChangePassword: ").append(this.allowUsersToChangePassword()).append(",");
        }
        if (this.maxPasswordAge() != null) {
            sb.append("MaxPasswordAge: ").append(this.maxPasswordAge()).append(",");
        }
        if (this.passwordReusePrevention() != null) {
            sb.append("PasswordReusePrevention: ").append(this.passwordReusePrevention()).append(",");
        }
        if (this.hardExpiry() != null) {
            sb.append("HardExpiry: ").append(this.hardExpiry()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumPasswordLength": {
                return Optional.of(clazz.cast(this.minimumPasswordLength()));
            }
            case "RequireSymbols": {
                return Optional.of(clazz.cast(this.requireSymbols()));
            }
            case "RequireNumbers": {
                return Optional.of(clazz.cast(this.requireNumbers()));
            }
            case "RequireUppercaseCharacters": {
                return Optional.of(clazz.cast(this.requireUppercaseCharacters()));
            }
            case "RequireLowercaseCharacters": {
                return Optional.of(clazz.cast(this.requireLowercaseCharacters()));
            }
            case "AllowUsersToChangePassword": {
                return Optional.of(clazz.cast(this.allowUsersToChangePassword()));
            }
            case "MaxPasswordAge": {
                return Optional.of(clazz.cast(this.maxPasswordAge()));
            }
            case "PasswordReusePrevention": {
                return Optional.of(clazz.cast(this.passwordReusePrevention()));
            }
            case "HardExpiry": {
                return Optional.of(clazz.cast(this.hardExpiry()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minimumPasswordLength;
        private Boolean requireSymbols;
        private Boolean requireNumbers;
        private Boolean requireUppercaseCharacters;
        private Boolean requireLowercaseCharacters;
        private Boolean allowUsersToChangePassword;
        private Integer maxPasswordAge;
        private Integer passwordReusePrevention;
        private Boolean hardExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountPasswordPolicyRequest model) {
            this.minimumPasswordLength(model.minimumPasswordLength);
            this.requireSymbols(model.requireSymbols);
            this.requireNumbers(model.requireNumbers);
            this.requireUppercaseCharacters(model.requireUppercaseCharacters);
            this.requireLowercaseCharacters(model.requireLowercaseCharacters);
            this.allowUsersToChangePassword(model.allowUsersToChangePassword);
            this.maxPasswordAge(model.maxPasswordAge);
            this.passwordReusePrevention(model.passwordReusePrevention);
            this.hardExpiry(model.hardExpiry);
        }

        public final Integer getMinimumPasswordLength() {
            return this.minimumPasswordLength;
        }

        @Override
        public final Builder minimumPasswordLength(Integer minimumPasswordLength) {
            this.minimumPasswordLength = minimumPasswordLength;
            return this;
        }

        public final void setMinimumPasswordLength(Integer minimumPasswordLength) {
            this.minimumPasswordLength = minimumPasswordLength;
        }

        public final Boolean getRequireSymbols() {
            return this.requireSymbols;
        }

        @Override
        public final Builder requireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        public final void setRequireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
        }

        public final Boolean getRequireNumbers() {
            return this.requireNumbers;
        }

        @Override
        public final Builder requireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
            return this;
        }

        public final void setRequireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
        }

        public final Boolean getRequireUppercaseCharacters() {
            return this.requireUppercaseCharacters;
        }

        @Override
        public final Builder requireUppercaseCharacters(Boolean requireUppercaseCharacters) {
            this.requireUppercaseCharacters = requireUppercaseCharacters;
            return this;
        }

        public final void setRequireUppercaseCharacters(Boolean requireUppercaseCharacters) {
            this.requireUppercaseCharacters = requireUppercaseCharacters;
        }

        public final Boolean getRequireLowercaseCharacters() {
            return this.requireLowercaseCharacters;
        }

        @Override
        public final Builder requireLowercaseCharacters(Boolean requireLowercaseCharacters) {
            this.requireLowercaseCharacters = requireLowercaseCharacters;
            return this;
        }

        public final void setRequireLowercaseCharacters(Boolean requireLowercaseCharacters) {
            this.requireLowercaseCharacters = requireLowercaseCharacters;
        }

        public final Boolean getAllowUsersToChangePassword() {
            return this.allowUsersToChangePassword;
        }

        @Override
        public final Builder allowUsersToChangePassword(Boolean allowUsersToChangePassword) {
            this.allowUsersToChangePassword = allowUsersToChangePassword;
            return this;
        }

        public final void setAllowUsersToChangePassword(Boolean allowUsersToChangePassword) {
            this.allowUsersToChangePassword = allowUsersToChangePassword;
        }

        public final Integer getMaxPasswordAge() {
            return this.maxPasswordAge;
        }

        @Override
        public final Builder maxPasswordAge(Integer maxPasswordAge) {
            this.maxPasswordAge = maxPasswordAge;
            return this;
        }

        public final void setMaxPasswordAge(Integer maxPasswordAge) {
            this.maxPasswordAge = maxPasswordAge;
        }

        public final Integer getPasswordReusePrevention() {
            return this.passwordReusePrevention;
        }

        @Override
        public final Builder passwordReusePrevention(Integer passwordReusePrevention) {
            this.passwordReusePrevention = passwordReusePrevention;
            return this;
        }

        public final void setPasswordReusePrevention(Integer passwordReusePrevention) {
            this.passwordReusePrevention = passwordReusePrevention;
        }

        public final Boolean getHardExpiry() {
            return this.hardExpiry;
        }

        @Override
        public final Builder hardExpiry(Boolean hardExpiry) {
            this.hardExpiry = hardExpiry;
            return this;
        }

        public final void setHardExpiry(Boolean hardExpiry) {
            this.hardExpiry = hardExpiry;
        }

        public UpdateAccountPasswordPolicyRequest build() {
            return new UpdateAccountPasswordPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateAccountPasswordPolicyRequest> {
        public Builder minimumPasswordLength(Integer var1);

        public Builder requireSymbols(Boolean var1);

        public Builder requireNumbers(Boolean var1);

        public Builder requireUppercaseCharacters(Boolean var1);

        public Builder requireLowercaseCharacters(Boolean var1);

        public Builder allowUsersToChangePassword(Boolean var1);

        public Builder maxPasswordAge(Integer var1);

        public Builder passwordReusePrevention(Integer var1);

        public Builder hardExpiry(Boolean var1);
    }
}

