/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ServiceSpecificCredentialMetadata
implements ToCopyableBuilder<Builder, ServiceSpecificCredentialMetadata> {
    private final String userName;
    private final String status;
    private final String serviceUserName;
    private final Instant createDate;
    private final String serviceSpecificCredentialId;
    private final String serviceName;

    private ServiceSpecificCredentialMetadata(BuilderImpl builder) {
        this.userName = builder.userName;
        this.status = builder.status;
        this.serviceUserName = builder.serviceUserName;
        this.createDate = builder.createDate;
        this.serviceSpecificCredentialId = builder.serviceSpecificCredentialId;
        this.serviceName = builder.serviceName;
    }

    public String userName() {
        return this.userName;
    }

    public StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String serviceUserName() {
        return this.serviceUserName;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public String serviceSpecificCredentialId() {
        return this.serviceSpecificCredentialId;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.serviceUserName() == null ? 0 : this.serviceUserName().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        hashCode = 31 * hashCode + (this.serviceSpecificCredentialId() == null ? 0 : this.serviceSpecificCredentialId().hashCode());
        hashCode = 31 * hashCode + (this.serviceName() == null ? 0 : this.serviceName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSpecificCredentialMetadata)) {
            return false;
        }
        ServiceSpecificCredentialMetadata other = (ServiceSpecificCredentialMetadata)obj;
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.serviceUserName() == null ^ this.serviceUserName() == null) {
            return false;
        }
        if (other.serviceUserName() != null && !other.serviceUserName().equals(this.serviceUserName())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.serviceSpecificCredentialId() == null ^ this.serviceSpecificCredentialId() == null) {
            return false;
        }
        if (other.serviceSpecificCredentialId() != null && !other.serviceSpecificCredentialId().equals(this.serviceSpecificCredentialId())) {
            return false;
        }
        if (other.serviceName() == null ^ this.serviceName() == null) {
            return false;
        }
        return other.serviceName() == null || other.serviceName().equals(this.serviceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.serviceUserName() != null) {
            sb.append("ServiceUserName: ").append(this.serviceUserName()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.serviceSpecificCredentialId() != null) {
            sb.append("ServiceSpecificCredentialId: ").append(this.serviceSpecificCredentialId()).append(",");
        }
        if (this.serviceName() != null) {
            sb.append("ServiceName: ").append(this.serviceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "ServiceUserName": {
                return Optional.of(clazz.cast(this.serviceUserName()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "ServiceSpecificCredentialId": {
                return Optional.of(clazz.cast(this.serviceSpecificCredentialId()));
            }
            case "ServiceName": {
                return Optional.of(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String status;
        private String serviceUserName;
        private Instant createDate;
        private String serviceSpecificCredentialId;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSpecificCredentialMetadata model) {
            this.userName(model.userName);
            this.status(model.status);
            this.serviceUserName(model.serviceUserName);
            this.createDate(model.createDate);
            this.serviceSpecificCredentialId(model.serviceSpecificCredentialId);
            this.serviceName(model.serviceName);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getServiceUserName() {
            return this.serviceUserName;
        }

        @Override
        public final Builder serviceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
            return this;
        }

        public final void setServiceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getServiceSpecificCredentialId() {
            return this.serviceSpecificCredentialId;
        }

        @Override
        public final Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        public final void setServiceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public ServiceSpecificCredentialMetadata build() {
            return new ServiceSpecificCredentialMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServiceSpecificCredentialMetadata> {
        public Builder userName(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder serviceUserName(String var1);

        public Builder createDate(Instant var1);

        public Builder serviceSpecificCredentialId(String var1);

        public Builder serviceName(String var1);
    }
}

