/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.PolicyVersion;
import software.amazon.awssdk.services.iam.model._policyDocumentVersionListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPolicyVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPolicyVersionsResponse> {
    private final List<PolicyVersion> versions;
    private final Boolean isTruncated;
    private final String marker;

    private ListPolicyVersionsResponse(BuilderImpl builder) {
        this.versions = builder.versions;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<PolicyVersion> versions() {
        return this.versions;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.versions() == null ? 0 : this.versions().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyVersionsResponse)) {
            return false;
        }
        ListPolicyVersionsResponse other = (ListPolicyVersionsResponse)((Object)obj);
        if (other.versions() == null ^ this.versions() == null) {
            return false;
        }
        if (other.versions() != null && !other.versions().equals(this.versions())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.versions() != null) {
            sb.append("Versions: ").append(this.versions()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Versions": {
                return Optional.of(clazz.cast(this.versions()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<PolicyVersion> versions;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyVersionsResponse model) {
            this.versions(model.versions);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<PolicyVersion.Builder> getVersions() {
            return this.versions != null ? (Collection)this.versions.stream().map(PolicyVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder versions(Collection<PolicyVersion> versions) {
            this.versions = _policyDocumentVersionListTypeCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(PolicyVersion ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<PolicyVersion.BuilderImpl> versions) {
            this.versions = _policyDocumentVersionListTypeCopier.copyFromBuilder(versions);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListPolicyVersionsResponse build() {
            return new ListPolicyVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPolicyVersionsResponse> {
        public Builder versions(Collection<PolicyVersion> var1);

        public Builder versions(PolicyVersion ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

