/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model._attachedPoliciesListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAttachedUserPoliciesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAttachedUserPoliciesResponse> {
    private final List<AttachedPolicy> attachedPolicies;
    private final Boolean isTruncated;
    private final String marker;

    private ListAttachedUserPoliciesResponse(BuilderImpl builder) {
        this.attachedPolicies = builder.attachedPolicies;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<AttachedPolicy> attachedPolicies() {
        return this.attachedPolicies;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attachedPolicies() == null ? 0 : this.attachedPolicies().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttachedUserPoliciesResponse)) {
            return false;
        }
        ListAttachedUserPoliciesResponse other = (ListAttachedUserPoliciesResponse)((Object)obj);
        if (other.attachedPolicies() == null ^ this.attachedPolicies() == null) {
            return false;
        }
        if (other.attachedPolicies() != null && !other.attachedPolicies().equals(this.attachedPolicies())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attachedPolicies() != null) {
            sb.append("AttachedPolicies: ").append(this.attachedPolicies()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachedPolicies": {
                return Optional.of(clazz.cast(this.attachedPolicies()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttachedPolicy> attachedPolicies;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttachedUserPoliciesResponse model) {
            this.attachedPolicies(model.attachedPolicies);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<AttachedPolicy.Builder> getAttachedPolicies() {
            return this.attachedPolicies != null ? (Collection)this.attachedPolicies.stream().map(AttachedPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachedPolicies(Collection<AttachedPolicy> attachedPolicies) {
            this.attachedPolicies = _attachedPoliciesListTypeCopier.copy(attachedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedPolicies(AttachedPolicy ... attachedPolicies) {
            this.attachedPolicies(Arrays.asList(attachedPolicies));
            return this;
        }

        public final void setAttachedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedPolicies) {
            this.attachedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedPolicies);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListAttachedUserPoliciesResponse build() {
            return new ListAttachedUserPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAttachedUserPoliciesResponse> {
        public Builder attachedPolicies(Collection<AttachedPolicy> var1);

        public Builder attachedPolicies(AttachedPolicy ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

