/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.iam.model.SimulationPolicyListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetContextKeysForPrincipalPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetContextKeysForPrincipalPolicyRequest> {
    private final String policySourceArn;
    private final List<String> policyInputList;

    private GetContextKeysForPrincipalPolicyRequest(BuilderImpl builder) {
        this.policySourceArn = builder.policySourceArn;
        this.policyInputList = builder.policyInputList;
    }

    public String policySourceArn() {
        return this.policySourceArn;
    }

    public List<String> policyInputList() {
        return this.policyInputList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policySourceArn() == null ? 0 : this.policySourceArn().hashCode());
        hashCode = 31 * hashCode + (this.policyInputList() == null ? 0 : this.policyInputList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContextKeysForPrincipalPolicyRequest)) {
            return false;
        }
        GetContextKeysForPrincipalPolicyRequest other = (GetContextKeysForPrincipalPolicyRequest)((Object)obj);
        if (other.policySourceArn() == null ^ this.policySourceArn() == null) {
            return false;
        }
        if (other.policySourceArn() != null && !other.policySourceArn().equals(this.policySourceArn())) {
            return false;
        }
        if (other.policyInputList() == null ^ this.policyInputList() == null) {
            return false;
        }
        return other.policyInputList() == null || other.policyInputList().equals(this.policyInputList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.policySourceArn() != null) {
            sb.append("PolicySourceArn: ").append(this.policySourceArn()).append(",");
        }
        if (this.policyInputList() != null) {
            sb.append("PolicyInputList: ").append(this.policyInputList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicySourceArn": {
                return Optional.of(clazz.cast(this.policySourceArn()));
            }
            case "PolicyInputList": {
                return Optional.of(clazz.cast(this.policyInputList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String policySourceArn;
        private List<String> policyInputList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContextKeysForPrincipalPolicyRequest model) {
            this.policySourceArn(model.policySourceArn);
            this.policyInputList(model.policyInputList);
        }

        public final String getPolicySourceArn() {
            return this.policySourceArn;
        }

        @Override
        public final Builder policySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
            return this;
        }

        public final void setPolicySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
        }

        public final Collection<String> getPolicyInputList() {
            return this.policyInputList;
        }

        @Override
        public final Builder policyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyInputList(String ... policyInputList) {
            this.policyInputList(Arrays.asList(policyInputList));
            return this;
        }

        public final void setPolicyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
        }

        public GetContextKeysForPrincipalPolicyRequest build() {
            return new GetContextKeysForPrincipalPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetContextKeysForPrincipalPolicyRequest> {
        public Builder policySourceArn(String var1);

        public Builder policyInputList(Collection<String> var1);

        public Builder policyInputList(String ... var1);
    }
}

