/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.Role;
import software.amazon.awssdk.services.iam.transform.AttachedPermissionsBoundaryUnmarshaller;

public class RoleUnmarshaller
implements Unmarshaller<Role, StaxUnmarshallerContext> {
    private static final RoleUnmarshaller INSTANCE = new RoleUnmarshaller();

    public Role unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Role.Builder role = Role.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Path", targetDepth)) {
                    role.path(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RoleName", targetDepth)) {
                    role.roleName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RoleId", targetDepth)) {
                    role.roleId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Arn", targetDepth)) {
                    role.arn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreateDate", targetDepth)) {
                    role.createDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AssumeRolePolicyDocument", targetDepth)) {
                    role.assumeRolePolicyDocument(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    role.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxSessionDuration", targetDepth)) {
                    role.maxSessionDuration(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PermissionsBoundary", targetDepth)) continue;
                role.permissionsBoundary(AttachedPermissionsBoundaryUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Role)role.build();
    }

    public static RoleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

