/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.PolicyDetail;
import software.amazon.awssdk.services.iam.model.RoleDetail;
import software.amazon.awssdk.services.iam.transform.AttachedPermissionsBoundaryUnmarshaller;
import software.amazon.awssdk.services.iam.transform.AttachedPolicyUnmarshaller;
import software.amazon.awssdk.services.iam.transform.InstanceProfileUnmarshaller;
import software.amazon.awssdk.services.iam.transform.PolicyDetailUnmarshaller;

public class RoleDetailUnmarshaller
implements Unmarshaller<RoleDetail, StaxUnmarshallerContext> {
    private static final RoleDetailUnmarshaller INSTANCE = new RoleDetailUnmarshaller();

    public RoleDetail unmarshall(StaxUnmarshallerContext context) throws Exception {
        RoleDetail.Builder roleDetail;
        block16: {
            roleDetail = RoleDetail.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<InstanceProfile> instanceProfileList = null;
            ArrayList<PolicyDetail> rolePolicyList = null;
            ArrayList<AttachedPolicy> attachedManagedPolicies = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    roleDetail.instanceProfileList(instanceProfileList);
                    roleDetail.rolePolicyList(rolePolicyList);
                    roleDetail.attachedManagedPolicies(attachedManagedPolicies);
                    break block16;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Path", targetDepth)) {
                        roleDetail.path(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RoleName", targetDepth)) {
                        roleDetail.roleName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RoleId", targetDepth)) {
                        roleDetail.roleId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Arn", targetDepth)) {
                        roleDetail.arn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CreateDate", targetDepth)) {
                        roleDetail.createDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AssumeRolePolicyDocument", targetDepth)) {
                        roleDetail.assumeRolePolicyDocument(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("InstanceProfileList", targetDepth)) {
                        instanceProfileList = new ArrayList<InstanceProfile>();
                        continue;
                    }
                    if (context.testExpression("InstanceProfileList/member", targetDepth)) {
                        instanceProfileList.add(InstanceProfileUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RolePolicyList", targetDepth)) {
                        rolePolicyList = new ArrayList<PolicyDetail>();
                        continue;
                    }
                    if (context.testExpression("RolePolicyList/member", targetDepth)) {
                        rolePolicyList.add(PolicyDetailUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AttachedManagedPolicies", targetDepth)) {
                        attachedManagedPolicies = new ArrayList<AttachedPolicy>();
                        continue;
                    }
                    if (context.testExpression("AttachedManagedPolicies/member", targetDepth)) {
                        attachedManagedPolicies.add(AttachedPolicyUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("PermissionsBoundary", targetDepth)) continue;
                    roleDetail.permissionsBoundary(AttachedPermissionsBoundaryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            roleDetail.instanceProfileList(instanceProfileList);
            roleDetail.rolePolicyList(rolePolicyList);
            roleDetail.attachedManagedPolicies(attachedManagedPolicies);
        }
        return (RoleDetail)roleDetail.build();
    }

    public static RoleDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}

