/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ListUsersRequest;

public class ListUsersRequestMarshaller
implements Marshaller<Request<ListUsersRequest>, ListUsersRequest> {
    public Request<ListUsersRequest> marshall(ListUsersRequest listUsersRequest) {
        if (listUsersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listUsersRequest, "IamClient");
        request.addParameter("Action", "ListUsers");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listUsersRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringConversion.fromString((String)listUsersRequest.pathPrefix()));
        }
        if (listUsersRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listUsersRequest.marker()));
        }
        if (listUsersRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)listUsersRequest.maxItems()));
        }
        return request;
    }
}

