/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest;

public class ListMfaDevicesRequestMarshaller
implements Marshaller<Request<ListMfaDevicesRequest>, ListMfaDevicesRequest> {
    public Request<ListMfaDevicesRequest> marshall(ListMfaDevicesRequest listMfaDevicesRequest) {
        if (listMfaDevicesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listMfaDevicesRequest, "IamClient");
        request.addParameter("Action", "ListMFADevices");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listMfaDevicesRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)listMfaDevicesRequest.userName()));
        }
        if (listMfaDevicesRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listMfaDevicesRequest.marker()));
        }
        if (listMfaDevicesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)listMfaDevicesRequest.maxItems()));
        }
        return request;
    }
}

