/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest;

public class ListGroupPoliciesRequestMarshaller
implements Marshaller<Request<ListGroupPoliciesRequest>, ListGroupPoliciesRequest> {
    public Request<ListGroupPoliciesRequest> marshall(ListGroupPoliciesRequest listGroupPoliciesRequest) {
        if (listGroupPoliciesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listGroupPoliciesRequest, "IamClient");
        request.addParameter("Action", "ListGroupPolicies");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listGroupPoliciesRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)listGroupPoliciesRequest.groupName()));
        }
        if (listGroupPoliciesRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listGroupPoliciesRequest.marker()));
        }
        if (listGroupPoliciesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)listGroupPoliciesRequest.maxItems()));
        }
        return request;
    }
}

