/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.GetUserPolicyRequest;

public class GetUserPolicyRequestMarshaller
implements Marshaller<Request<GetUserPolicyRequest>, GetUserPolicyRequest> {
    public Request<GetUserPolicyRequest> marshall(GetUserPolicyRequest getUserPolicyRequest) {
        if (getUserPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getUserPolicyRequest, "IamClient");
        request.addParameter("Action", "GetUserPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getUserPolicyRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)getUserPolicyRequest.userName()));
        }
        if (getUserPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString((String)getUserPolicyRequest.policyName()));
        }
        return request;
    }
}

