/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.GetGroupRequest;

public class GetGroupRequestMarshaller
implements Marshaller<Request<GetGroupRequest>, GetGroupRequest> {
    public Request<GetGroupRequest> marshall(GetGroupRequest getGroupRequest) {
        if (getGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getGroupRequest, "IamClient");
        request.addParameter("Action", "GetGroup");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)getGroupRequest.groupName()));
        }
        if (getGroupRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)getGroupRequest.marker()));
        }
        if (getGroupRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromInteger((Integer)getGroupRequest.maxItems()));
        }
        return request;
    }
}

