/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRoleRequest
extends IamRequest
implements ToCopyableBuilder<Builder, UpdateRoleRequest> {
    private final String roleName;
    private final String description;
    private final Integer maxSessionDuration;

    private UpdateRoleRequest(BuilderImpl builder) {
        super(builder);
        this.roleName = builder.roleName;
        this.description = builder.description;
        this.maxSessionDuration = builder.maxSessionDuration;
    }

    public String roleName() {
        return this.roleName;
    }

    public String description() {
        return this.description;
    }

    public Integer maxSessionDuration() {
        return this.maxSessionDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSessionDuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoleRequest)) {
            return false;
        }
        UpdateRoleRequest other = (UpdateRoleRequest)((Object)obj);
        return Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.maxSessionDuration(), other.maxSessionDuration());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRoleRequest").add("RoleName", (Object)this.roleName()).add("Description", (Object)this.description()).add("MaxSessionDuration", (Object)this.maxSessionDuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MaxSessionDuration": {
                return Optional.ofNullable(clazz.cast(this.maxSessionDuration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String roleName;
        private String description;
        private Integer maxSessionDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoleRequest model) {
            super(model);
            this.roleName(model.roleName);
            this.description(model.description);
            this.maxSessionDuration(model.maxSessionDuration);
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getMaxSessionDuration() {
            return this.maxSessionDuration;
        }

        @Override
        public final Builder maxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
            return this;
        }

        public final void setMaxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoleRequest build() {
            return new UpdateRoleRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, UpdateRoleRequest> {
        public Builder roleName(String var1);

        public Builder description(String var1);

        public Builder maxSessionDuration(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

