/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGroupRequest
extends IamRequest
implements ToCopyableBuilder<Builder, UpdateGroupRequest> {
    private final String groupName;
    private final String newPath;
    private final String newGroupName;

    private UpdateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.newPath = builder.newPath;
        this.newGroupName = builder.newGroupName;
    }

    public String groupName() {
        return this.groupName;
    }

    public String newPath() {
        return this.newPath;
    }

    public String newGroupName() {
        return this.newGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.newGroupName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest other = (UpdateGroupRequest)((Object)obj);
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.newPath(), other.newPath()) && Objects.equals(this.newGroupName(), other.newGroupName());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGroupRequest").add("GroupName", (Object)this.groupName()).add("NewPath", (Object)this.newPath()).add("NewGroupName", (Object)this.newGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "NewPath": {
                return Optional.ofNullable(clazz.cast(this.newPath()));
            }
            case "NewGroupName": {
                return Optional.ofNullable(clazz.cast(this.newGroupName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String groupName;
        private String newPath;
        private String newGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupRequest model) {
            super(model);
            this.groupName(model.groupName);
            this.newPath(model.newPath);
            this.newGroupName(model.newGroupName);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getNewPath() {
            return this.newPath;
        }

        @Override
        public final Builder newPath(String newPath) {
            this.newPath = newPath;
            return this;
        }

        public final void setNewPath(String newPath) {
            this.newPath = newPath;
        }

        public final String getNewGroupName() {
            return this.newGroupName;
        }

        @Override
        public final Builder newGroupName(String newGroupName) {
            this.newGroupName = newGroupName;
            return this;
        }

        public final void setNewGroupName(String newGroupName) {
            this.newGroupName = newGroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGroupRequest build() {
            return new UpdateGroupRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, UpdateGroupRequest> {
        public Builder groupName(String var1);

        public Builder newPath(String var1);

        public Builder newGroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

