/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.AttachedPermissionsBoundary;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.PolicyDetail;
import software.amazon.awssdk.services.iam.model._attachedPoliciesListTypeCopier;
import software.amazon.awssdk.services.iam.model._instanceProfileListTypeCopier;
import software.amazon.awssdk.services.iam.model._policyDetailListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoleDetail
implements ToCopyableBuilder<Builder, RoleDetail> {
    private final String path;
    private final String roleName;
    private final String roleId;
    private final String arn;
    private final Instant createDate;
    private final String assumeRolePolicyDocument;
    private final List<InstanceProfile> instanceProfileList;
    private final List<PolicyDetail> rolePolicyList;
    private final List<AttachedPolicy> attachedManagedPolicies;
    private final AttachedPermissionsBoundary permissionsBoundary;

    private RoleDetail(BuilderImpl builder) {
        this.path = builder.path;
        this.roleName = builder.roleName;
        this.roleId = builder.roleId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.instanceProfileList = builder.instanceProfileList;
        this.rolePolicyList = builder.rolePolicyList;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
        this.permissionsBoundary = builder.permissionsBoundary;
    }

    public String path() {
        return this.path;
    }

    public String roleName() {
        return this.roleName;
    }

    public String roleId() {
        return this.roleId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public String assumeRolePolicyDocument() {
        return this.assumeRolePolicyDocument;
    }

    public List<InstanceProfile> instanceProfileList() {
        return this.instanceProfileList;
    }

    public List<PolicyDetail> rolePolicyList() {
        return this.rolePolicyList;
    }

    public List<AttachedPolicy> attachedManagedPolicies() {
        return this.attachedManagedPolicies;
    }

    public AttachedPermissionsBoundary permissionsBoundary() {
        return this.permissionsBoundary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileList());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolePolicyList());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedManagedPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleDetail)) {
            return false;
        }
        RoleDetail other = (RoleDetail)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.roleId(), other.roleId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.assumeRolePolicyDocument(), other.assumeRolePolicyDocument()) && Objects.equals(this.instanceProfileList(), other.instanceProfileList()) && Objects.equals(this.rolePolicyList(), other.rolePolicyList()) && Objects.equals(this.attachedManagedPolicies(), other.attachedManagedPolicies()) && Objects.equals(this.permissionsBoundary(), other.permissionsBoundary());
    }

    public String toString() {
        return ToString.builder((String)"RoleDetail").add("Path", (Object)this.path()).add("RoleName", (Object)this.roleName()).add("RoleId", (Object)this.roleId()).add("Arn", (Object)this.arn()).add("CreateDate", (Object)this.createDate()).add("AssumeRolePolicyDocument", (Object)this.assumeRolePolicyDocument()).add("InstanceProfileList", this.instanceProfileList()).add("RolePolicyList", this.rolePolicyList()).add("AttachedManagedPolicies", this.attachedManagedPolicies()).add("PermissionsBoundary", (Object)this.permissionsBoundary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "RoleId": {
                return Optional.ofNullable(clazz.cast(this.roleId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "AssumeRolePolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.assumeRolePolicyDocument()));
            }
            case "InstanceProfileList": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileList()));
            }
            case "RolePolicyList": {
                return Optional.ofNullable(clazz.cast(this.rolePolicyList()));
            }
            case "AttachedManagedPolicies": {
                return Optional.ofNullable(clazz.cast(this.attachedManagedPolicies()));
            }
            case "PermissionsBoundary": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundary()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String roleName;
        private String roleId;
        private String arn;
        private Instant createDate;
        private String assumeRolePolicyDocument;
        private List<InstanceProfile> instanceProfileList = DefaultSdkAutoConstructList.getInstance();
        private List<PolicyDetail> rolePolicyList = DefaultSdkAutoConstructList.getInstance();
        private List<AttachedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();
        private AttachedPermissionsBoundary permissionsBoundary;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleDetail model) {
            this.path(model.path);
            this.roleName(model.roleName);
            this.roleId(model.roleId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            this.instanceProfileList(model.instanceProfileList);
            this.rolePolicyList(model.rolePolicyList);
            this.attachedManagedPolicies(model.attachedManagedPolicies);
            this.permissionsBoundary(model.permissionsBoundary);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getRoleId() {
            return this.roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getAssumeRolePolicyDocument() {
            return this.assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        public final Collection<InstanceProfile.Builder> getInstanceProfileList() {
            return this.instanceProfileList != null ? (Collection)this.instanceProfileList.stream().map(InstanceProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceProfileList(Collection<InstanceProfile> instanceProfileList) {
            this.instanceProfileList = _instanceProfileListTypeCopier.copy(instanceProfileList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfileList(InstanceProfile ... instanceProfileList) {
            this.instanceProfileList(Arrays.asList(instanceProfileList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfileList(Consumer<InstanceProfile.Builder> ... instanceProfileList) {
            this.instanceProfileList(Stream.of(instanceProfileList).map(c -> (InstanceProfile)((InstanceProfile.Builder)InstanceProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceProfileList(Collection<InstanceProfile.BuilderImpl> instanceProfileList) {
            this.instanceProfileList = _instanceProfileListTypeCopier.copyFromBuilder(instanceProfileList);
        }

        public final Collection<PolicyDetail.Builder> getRolePolicyList() {
            return this.rolePolicyList != null ? (Collection)this.rolePolicyList.stream().map(PolicyDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rolePolicyList(Collection<PolicyDetail> rolePolicyList) {
            this.rolePolicyList = _policyDetailListTypeCopier.copy(rolePolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePolicyList(PolicyDetail ... rolePolicyList) {
            this.rolePolicyList(Arrays.asList(rolePolicyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePolicyList(Consumer<PolicyDetail.Builder> ... rolePolicyList) {
            this.rolePolicyList(Stream.of(rolePolicyList).map(c -> (PolicyDetail)((PolicyDetail.Builder)PolicyDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRolePolicyList(Collection<PolicyDetail.BuilderImpl> rolePolicyList) {
            this.rolePolicyList = _policyDetailListTypeCopier.copyFromBuilder(rolePolicyList);
        }

        public final Collection<AttachedPolicy.Builder> getAttachedManagedPolicies() {
            return this.attachedManagedPolicies != null ? (Collection)this.attachedManagedPolicies.stream().map(AttachedPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedPolicy ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder> ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Stream.of(attachedManagedPolicies).map(c -> (AttachedPolicy)((AttachedPolicy.Builder)AttachedPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedManagedPolicies);
        }

        public final AttachedPermissionsBoundary.Builder getPermissionsBoundary() {
            return this.permissionsBoundary != null ? this.permissionsBoundary.toBuilder() : null;
        }

        @Override
        public final Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final void setPermissionsBoundary(AttachedPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        public RoleDetail build() {
            return new RoleDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RoleDetail> {
        public Builder path(String var1);

        public Builder roleName(String var1);

        public Builder roleId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder assumeRolePolicyDocument(String var1);

        public Builder instanceProfileList(Collection<InstanceProfile> var1);

        public Builder instanceProfileList(InstanceProfile ... var1);

        public Builder instanceProfileList(Consumer<InstanceProfile.Builder> ... var1);

        public Builder rolePolicyList(Collection<PolicyDetail> var1);

        public Builder rolePolicyList(PolicyDetail ... var1);

        public Builder rolePolicyList(Consumer<PolicyDetail.Builder> ... var1);

        public Builder attachedManagedPolicies(Collection<AttachedPolicy> var1);

        public Builder attachedManagedPolicies(AttachedPolicy ... var1);

        public Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder> ... var1);

        public Builder permissionsBoundary(AttachedPermissionsBoundary var1);

        default public Builder permissionsBoundary(Consumer<AttachedPermissionsBoundary.Builder> permissionsBoundary) {
            return this.permissionsBoundary((AttachedPermissionsBoundary)((AttachedPermissionsBoundary.Builder)AttachedPermissionsBoundary.builder().applyMutation(permissionsBoundary)).build());
        }
    }
}

