/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRolePermissionsBoundaryRequest
extends IamRequest
implements ToCopyableBuilder<Builder, PutRolePermissionsBoundaryRequest> {
    private final String roleName;
    private final String permissionsBoundary;

    private PutRolePermissionsBoundaryRequest(BuilderImpl builder) {
        super(builder);
        this.roleName = builder.roleName;
        this.permissionsBoundary = builder.permissionsBoundary;
    }

    public String roleName() {
        return this.roleName;
    }

    public String permissionsBoundary() {
        return this.permissionsBoundary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRolePermissionsBoundaryRequest)) {
            return false;
        }
        PutRolePermissionsBoundaryRequest other = (PutRolePermissionsBoundaryRequest)((Object)obj);
        return Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.permissionsBoundary(), other.permissionsBoundary());
    }

    public String toString() {
        return ToString.builder((String)"PutRolePermissionsBoundaryRequest").add("RoleName", (Object)this.roleName()).add("PermissionsBoundary", (Object)this.permissionsBoundary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "PermissionsBoundary": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundary()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String roleName;
        private String permissionsBoundary;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRolePermissionsBoundaryRequest model) {
            super(model);
            this.roleName(model.roleName);
            this.permissionsBoundary(model.permissionsBoundary);
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getPermissionsBoundary() {
            return this.permissionsBoundary;
        }

        @Override
        public final Builder permissionsBoundary(String permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final void setPermissionsBoundary(String permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRolePermissionsBoundaryRequest build() {
            return new PutRolePermissionsBoundaryRequest(this);
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    CopyableBuilder<Builder, PutRolePermissionsBoundaryRequest> {
        public Builder roleName(String var1);

        public Builder permissionsBoundary(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

