/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialRequest;

public class UpdateServiceSpecificCredentialRequestMarshaller
implements Marshaller<Request<UpdateServiceSpecificCredentialRequest>, UpdateServiceSpecificCredentialRequest> {
    public Request<UpdateServiceSpecificCredentialRequest> marshall(UpdateServiceSpecificCredentialRequest updateServiceSpecificCredentialRequest) {
        if (updateServiceSpecificCredentialRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateServiceSpecificCredentialRequest, "IamClient");
        request.addParameter("Action", "UpdateServiceSpecificCredential");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateServiceSpecificCredentialRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)updateServiceSpecificCredentialRequest.userName()));
        }
        if (updateServiceSpecificCredentialRequest.serviceSpecificCredentialId() != null) {
            request.addParameter("ServiceSpecificCredentialId", StringConversion.fromString((String)updateServiceSpecificCredentialRequest.serviceSpecificCredentialId()));
        }
        if (updateServiceSpecificCredentialRequest.statusAsString() != null) {
            request.addParameter("Status", StringConversion.fromString((String)updateServiceSpecificCredentialRequest.statusAsString()));
        }
        return request;
    }
}

