/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.ResyncMfaDeviceRequest;

public class ResyncMfaDeviceRequestMarshaller
implements Marshaller<Request<ResyncMfaDeviceRequest>, ResyncMfaDeviceRequest> {
    public Request<ResyncMfaDeviceRequest> marshall(ResyncMfaDeviceRequest resyncMfaDeviceRequest) {
        if (resyncMfaDeviceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)resyncMfaDeviceRequest, "IamClient");
        request.addParameter("Action", "ResyncMFADevice");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (resyncMfaDeviceRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)resyncMfaDeviceRequest.userName()));
        }
        if (resyncMfaDeviceRequest.serialNumber() != null) {
            request.addParameter("SerialNumber", StringConversion.fromString((String)resyncMfaDeviceRequest.serialNumber()));
        }
        if (resyncMfaDeviceRequest.authenticationCode1() != null) {
            request.addParameter("AuthenticationCode1", StringConversion.fromString((String)resyncMfaDeviceRequest.authenticationCode1()));
        }
        if (resyncMfaDeviceRequest.authenticationCode2() != null) {
            request.addParameter("AuthenticationCode2", StringConversion.fromString((String)resyncMfaDeviceRequest.authenticationCode2()));
        }
        return request;
    }
}

