/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.GetSshPublicKeyRequest;

public class GetSshPublicKeyRequestMarshaller
implements Marshaller<Request<GetSshPublicKeyRequest>, GetSshPublicKeyRequest> {
    public Request<GetSshPublicKeyRequest> marshall(GetSshPublicKeyRequest getSshPublicKeyRequest) {
        if (getSshPublicKeyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getSshPublicKeyRequest, "IamClient");
        request.addParameter("Action", "GetSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getSshPublicKeyRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)getSshPublicKeyRequest.userName()));
        }
        if (getSshPublicKeyRequest.sshPublicKeyId() != null) {
            request.addParameter("SSHPublicKeyId", StringConversion.fromString((String)getSshPublicKeyRequest.sshPublicKeyId()));
        }
        if (getSshPublicKeyRequest.encodingAsString() != null) {
            request.addParameter("Encoding", StringConversion.fromString((String)getSshPublicKeyRequest.encodingAsString()));
        }
        return request;
    }
}

