/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.EnableMfaDeviceRequest;

public class EnableMfaDeviceRequestMarshaller
implements Marshaller<Request<EnableMfaDeviceRequest>, EnableMfaDeviceRequest> {
    public Request<EnableMfaDeviceRequest> marshall(EnableMfaDeviceRequest enableMfaDeviceRequest) {
        if (enableMfaDeviceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)enableMfaDeviceRequest, "IamClient");
        request.addParameter("Action", "EnableMFADevice");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableMfaDeviceRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)enableMfaDeviceRequest.userName()));
        }
        if (enableMfaDeviceRequest.serialNumber() != null) {
            request.addParameter("SerialNumber", StringConversion.fromString((String)enableMfaDeviceRequest.serialNumber()));
        }
        if (enableMfaDeviceRequest.authenticationCode1() != null) {
            request.addParameter("AuthenticationCode1", StringConversion.fromString((String)enableMfaDeviceRequest.authenticationCode1()));
        }
        if (enableMfaDeviceRequest.authenticationCode2() != null) {
            request.addParameter("AuthenticationCode2", StringConversion.fromString((String)enableMfaDeviceRequest.authenticationCode2()));
        }
        return request;
    }
}

