/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyRequest;

public class DeleteSshPublicKeyRequestMarshaller
implements Marshaller<Request<DeleteSshPublicKeyRequest>, DeleteSshPublicKeyRequest> {
    public Request<DeleteSshPublicKeyRequest> marshall(DeleteSshPublicKeyRequest deleteSshPublicKeyRequest) {
        if (deleteSshPublicKeyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteSshPublicKeyRequest, "IamClient");
        request.addParameter("Action", "DeleteSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteSshPublicKeyRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)deleteSshPublicKeyRequest.userName()));
        }
        if (deleteSshPublicKeyRequest.sshPublicKeyId() != null) {
            request.addParameter("SSHPublicKeyId", StringConversion.fromString((String)deleteSshPublicKeyRequest.sshPublicKeyId()));
        }
        return request;
    }
}

