/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.CreateUserRequest;

public class CreateUserRequestMarshaller
implements Marshaller<Request<CreateUserRequest>, CreateUserRequest> {
    public Request<CreateUserRequest> marshall(CreateUserRequest createUserRequest) {
        if (createUserRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createUserRequest, "IamClient");
        request.addParameter("Action", "CreateUser");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createUserRequest.path() != null) {
            request.addParameter("Path", StringConversion.fromString((String)createUserRequest.path()));
        }
        if (createUserRequest.userName() != null) {
            request.addParameter("UserName", StringConversion.fromString((String)createUserRequest.userName()));
        }
        return request;
    }
}

