/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderRequest;

public class CreateOpenIdConnectProviderRequestMarshaller
implements Marshaller<Request<CreateOpenIdConnectProviderRequest>, CreateOpenIdConnectProviderRequest> {
    public Request<CreateOpenIdConnectProviderRequest> marshall(CreateOpenIdConnectProviderRequest createOpenIdConnectProviderRequest) {
        if (createOpenIdConnectProviderRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createOpenIdConnectProviderRequest, "IamClient");
        request.addParameter("Action", "CreateOpenIDConnectProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createOpenIdConnectProviderRequest.url() != null) {
            request.addParameter("Url", StringConversion.fromString((String)createOpenIdConnectProviderRequest.url()));
        }
        if (createOpenIdConnectProviderRequest.clientIDList().isEmpty() && !(createOpenIdConnectProviderRequest.clientIDList() instanceof SdkAutoConstructList)) {
            request.addParameter("ClientIDList", "");
        } else if (!createOpenIdConnectProviderRequest.clientIDList().isEmpty() && !(createOpenIdConnectProviderRequest.clientIDList() instanceof SdkAutoConstructList)) {
            List<String> clientIDListList = createOpenIdConnectProviderRequest.clientIDList();
            int clientIDListListIndex = 1;
            for (String clientIDListListValue : clientIDListList) {
                if (clientIDListListValue != null) {
                    request.addParameter("ClientIDList.member." + clientIDListListIndex, StringConversion.fromString((String)clientIDListListValue));
                }
                ++clientIDListListIndex;
            }
        }
        if (createOpenIdConnectProviderRequest.thumbprintList().isEmpty() && !(createOpenIdConnectProviderRequest.thumbprintList() instanceof SdkAutoConstructList)) {
            request.addParameter("ThumbprintList", "");
        } else if (!createOpenIdConnectProviderRequest.thumbprintList().isEmpty() && !(createOpenIdConnectProviderRequest.thumbprintList() instanceof SdkAutoConstructList)) {
            List<String> thumbprintListList = createOpenIdConnectProviderRequest.thumbprintList();
            int thumbprintListListIndex = 1;
            for (String thumbprintListListValue : thumbprintListList) {
                if (thumbprintListListValue != null) {
                    request.addParameter("ThumbprintList.member." + thumbprintListListIndex, StringConversion.fromString((String)thumbprintListListValue));
                }
                ++thumbprintListListIndex;
            }
        }
        return request;
    }
}

