/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest;

public class CreateInstanceProfileRequestMarshaller
implements Marshaller<Request<CreateInstanceProfileRequest>, CreateInstanceProfileRequest> {
    public Request<CreateInstanceProfileRequest> marshall(CreateInstanceProfileRequest createInstanceProfileRequest) {
        if (createInstanceProfileRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createInstanceProfileRequest, "IamClient");
        request.addParameter("Action", "CreateInstanceProfile");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createInstanceProfileRequest.instanceProfileName() != null) {
            request.addParameter("InstanceProfileName", StringConversion.fromString((String)createInstanceProfileRequest.instanceProfileName()));
        }
        if (createInstanceProfileRequest.path() != null) {
            request.addParameter("Path", StringConversion.fromString((String)createInstanceProfileRequest.path()));
        }
        return request;
    }
}

